<?php

namespace Database\Seeders\Admin;

use App\Models\Admin\Currency;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class CurrencySeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {

        $currencies = array(
            array('admin_id' => '1','country' => 'United States','name' => 'United States dollar','code' => 'USD','symbol' => '$','type' => 'FIAT','flag' => 'seeder/USD.png','rate' => '1.00000000','sender' => '1','receiver' => '1','default' => '1','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'United Kingdom','name' => 'British pound','code' => 'GBP','symbol' => '£','type' => 'FIAT','flag' => 'seeder/GBP.png','rate' => '0.74621000','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Australia','name' => 'Australian dollar','code' => 'AUD','symbol' => '$','type' => 'FIAT','flag' => 'seeder/AUD.png','rate' => '1.45455500','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Canada','name' => 'Canadian dollar','code' => 'CAD','symbol' => '$','type' => 'FIAT','flag' => 'seeder/CAD.jpg','rate' => '1.34472000','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Germany','name' => 'Euro','code' => 'EUR','symbol' => '€','type' => 'FIAT','flag' => 'seeder/EUR.jpg','rate' => '0.89269500','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Nigeria','name' => 'Nigerian naira','code' => 'NGN','symbol' => '₦','type' => 'FIAT','flag' => 'seeder/NGN.jpg','rate' => '1639.25960200','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Pakistan','name' => 'Pakistani rupee','code' => 'PKR','symbol' => 'Rs','type' => 'FIAT','flag' => 'seeder/PKR.png','rate' => '277.84737600','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'India','name' => 'Indian rupee','code' => 'INR','symbol' => '₹','type' => 'FIAT','flag' => 'seeder/INR.png','rate' => '83.58185000','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Bangladesh','name' => 'Bangladeshi taka','code' => 'BDT','symbol' => '৳','type' => 'FIAT','flag' => 'seeder/BDT.png','rate' => '119.51172600','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Kenya','name' => 'Kenyan shilling','code' => 'KES','symbol' => 'KSh','type' => 'FIAT','flag' => 'seeder/KES.png','rate' => '129.01010200','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Cote D\'Ivoire (Ivory Coast)','name' => 'West African CFA franc','code' => 'XOF','symbol' => 'CFA','type' => 'FIAT','flag' => 'seeder/XOF.webp','rate' => '586.39055600','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'South Africa','name' => 'South African rand','code' => 'ZAR','symbol' => 'R','type' => 'FIAT','flag' => 'seeder/zar.png','rate' => '17.16271000','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'El Salvador','name' => 'El Salvador Bitcoin','code' => 'BTC','symbol' => '₿','type' => 'CRYPTO','flag' => NULL,'rate' => '0.00001573','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'United Arab Emirates','name' => 'United Arab Emirates dirham','code' => 'AED','symbol' => 'إ.د','type' => 'FIAT','flag' => NULL,'rate' => '3.67300000','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Afghanistan','name' => 'Afghan afghani','code' => 'AFN','symbol' => '؋','type' => 'FIAT','flag' => NULL,'rate' => '68.46737300','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Albania','name' => 'Albanian lek','code' => 'ALL','symbol' => 'Lek','type' => 'FIAT','flag' => NULL,'rate' => '88.52753600','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Armenia','name' => 'Armenian dram','code' => 'AMD','symbol' => '֏','type' => 'FIAT','flag' => NULL,'rate' => '387.51556200','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Angola','name' => 'Angolan kwanza','code' => 'AOA','symbol' => 'Kz','type' => 'FIAT','flag' => NULL,'rate' => '936.49828900','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Argentina','name' => 'Argentine peso','code' => 'ARS','symbol' => '$','type' => 'FIAT','flag' => NULL,'rate' => '967.25025000','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Aruba','name' => 'Aruban florin','code' => 'AWG','symbol' => 'ƒ','type' => 'FIAT','flag' => NULL,'rate' => '1.80000000','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Azerbaijan','name' => 'Azerbaijani manat','code' => 'AZN','symbol' => 'm','type' => 'FIAT','flag' => NULL,'rate' => '1.70152200','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Bosnia and Herzegovina','name' => 'Bosnia and Herzegovina convertible mark','code' => 'BAM','symbol' => 'KM','type' => 'FIAT','flag' => NULL,'rate' => '1.74838100','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Barbados','name' => 'Barbadian dollar','code' => 'BBD','symbol' => 'Bds$','type' => 'FIAT','flag' => NULL,'rate' => '2.01924700','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Bulgaria','name' => 'Bulgarian lev','code' => 'BGN','symbol' => 'Лв.','type' => 'FIAT','flag' => NULL,'rate' => '1.74799000','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Bahrain','name' => 'Bahraini dinar','code' => 'BHD','symbol' => '.د.ب','type' => 'FIAT','flag' => NULL,'rate' => '0.37676700','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Burundi','name' => 'Burundian franc','code' => 'BIF','symbol' => 'FBu','type' => 'FIAT','flag' => NULL,'rate' => '2899.87350700','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Bermuda','name' => 'Bermudian dollar','code' => 'BMD','symbol' => '$','type' => 'FIAT','flag' => NULL,'rate' => '1.00000000','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Brunei','name' => 'Brunei dollar','code' => 'BND','symbol' => 'B$','type' => 'FIAT','flag' => NULL,'rate' => '1.28531600','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Bolivia','name' => 'Bolivian boliviano','code' => 'BOB','symbol' => 'Bs.','type' => 'FIAT','flag' => NULL,'rate' => '6.91023800','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Brazil','name' => 'Brazilian real','code' => 'BRL','symbol' => 'R$','type' => 'FIAT','flag' => NULL,'rate' => '5.46740300','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'The Bahamas','name' => 'Bahamian dollar','code' => 'BSD','symbol' => 'B$','type' => 'FIAT','flag' => NULL,'rate' => '1.00005800','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Bhutan','name' => 'Bhutanese ngultrum','code' => 'BTN','symbol' => 'Nu.','type' => 'FIAT','flag' => NULL,'rate' => '83.64411700','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Botswana','name' => 'Botswana pula','code' => 'BWP','symbol' => 'P','type' => 'FIAT','flag' => NULL,'rate' => '13.09035300','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Belarus','name' => 'Belarusian ruble','code' => 'BYN','symbol' => 'Br','type' => 'FIAT','flag' => NULL,'rate' => '3.27282800','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Belize','name' => 'Belize dollar','code' => 'BZD','symbol' => '$','type' => 'FIAT','flag' => NULL,'rate' => '2.01586800','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Democratic Republic of the Congo','name' => 'Congolese Franc','code' => 'CDF','symbol' => 'FC','type' => 'FIAT','flag' => NULL,'rate' => '2865.49760900','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Switzerland','name' => 'Swiss franc','code' => 'CHF','symbol' => 'CHf','type' => 'FIAT','flag' => NULL,'rate' => '0.84762000','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Chile','name' => 'Chilean peso','code' => 'CLP','symbol' => '$','type' => 'FIAT','flag' => NULL,'rate' => '914.70994600','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'China','name' => 'Chinese yuan','code' => 'CNY','symbol' => '¥','type' => 'FIAT','flag' => NULL,'rate' => '7.02889800','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Colombia','name' => 'Colombian peso','code' => 'COP','symbol' => '$','type' => 'FIAT','flag' => NULL,'rate' => '4156.38000000','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Costa Rica','name' => 'Costa Rican colón','code' => 'CRC','symbol' => '₡','type' => 'FIAT','flag' => NULL,'rate' => '517.95731400','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Cuba','name' => 'Cuban peso','code' => 'CUP','symbol' => '$','type' => 'FIAT','flag' => NULL,'rate' => '26.50000000','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Cape Verde','name' => 'Cape Verdean escudo','code' => 'CVE','symbol' => '$','type' => 'FIAT','flag' => NULL,'rate' => '98.57190700','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Czech Republic','name' => 'Czech koruna','code' => 'CZK','symbol' => 'Kč','type' => 'FIAT','flag' => NULL,'rate' => '22.40380200','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Djibouti','name' => 'Djiboutian franc','code' => 'DJF','symbol' => 'Fdj','type' => 'FIAT','flag' => NULL,'rate' => '178.09364200','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Dominican Republic','name' => 'Dominican peso','code' => 'DOP','symbol' => '$','type' => 'FIAT','flag' => NULL,'rate' => '59.96594100','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Algeria','name' => 'Algerian dinar','code' => 'DZD','symbol' => 'دج','type' => 'FIAT','flag' => NULL,'rate' => '132.34282800','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Egypt','name' => 'Egyptian pound','code' => 'EGP','symbol' => 'ج.م','type' => 'FIAT','flag' => NULL,'rate' => '48.56049800','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Eritrea','name' => 'Eritrean nakfa','code' => 'ERN','symbol' => 'Nfk','type' => 'FIAT','flag' => NULL,'rate' => '15.00000000','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Ethiopia','name' => 'Ethiopian birr','code' => 'ETB','symbol' => 'Nkf','type' => 'FIAT','flag' => NULL,'rate' => '119.26579800','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Fiji Islands','name' => 'Fijian dollar','code' => 'FJD','symbol' => 'FJ$','type' => 'FIAT','flag' => NULL,'rate' => '2.18920300','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Falkland Islands','name' => 'Falkland Islands pound','code' => 'FKP','symbol' => '£','type' => 'FIAT','flag' => NULL,'rate' => '0.76155900','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Georgia','name' => 'Georgian lari','code' => 'GEL','symbol' => 'ლ','type' => 'FIAT','flag' => NULL,'rate' => '2.72499400','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Ghana','name' => 'Ghanaian cedi','code' => 'GHS','symbol' => 'GH₵','type' => 'FIAT','flag' => NULL,'rate' => '15.74831300','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Gibraltar','name' => 'Gibraltar pound','code' => 'GIP','symbol' => '£','type' => 'FIAT','flag' => NULL,'rate' => '0.76155900','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Gambia The','name' => 'Gambian dalasi','code' => 'GMD','symbol' => 'D','type' => 'FIAT','flag' => NULL,'rate' => '68.49870800','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Guinea','name' => 'Guinean franc','code' => 'GNF','symbol' => 'FG','type' => 'FIAT','flag' => NULL,'rate' => '8639.10033200','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Guatemala','name' => 'Guatemalan quetzal','code' => 'GTQ','symbol' => 'Q','type' => 'FIAT','flag' => NULL,'rate' => '7.73085100','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Guyana','name' => 'Guyanese dollar','code' => 'GYD','symbol' => '$','type' => 'FIAT','flag' => NULL,'rate' => '209.19432300','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Hong Kong S.A.R.','name' => 'Hong Kong dollar','code' => 'HKD','symbol' => '$','type' => 'FIAT','flag' => NULL,'rate' => '7.78632500','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Honduras','name' => 'Honduran lempira','code' => 'HNL','symbol' => 'L','type' => 'FIAT','flag' => NULL,'rate' => '24.84367100','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Croatia','name' => 'Croatian kuna','code' => 'HRK','symbol' => 'kn','type' => 'FIAT','flag' => NULL,'rate' => '6.79901100','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Haiti','name' => 'Haitian gourde','code' => 'HTG','symbol' => 'G','type' => 'FIAT','flag' => NULL,'rate' => '132.00910000','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Hungary','name' => 'Hungarian forint','code' => 'HUF','symbol' => 'Ft','type' => 'FIAT','flag' => NULL,'rate' => '352.34503100','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Indonesia','name' => 'Indonesian rupiah','code' => 'IDR','symbol' => 'Rp','type' => 'FIAT','flag' => NULL,'rate' => '15121.05000000','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Israel','name' => 'Israeli new shekel','code' => 'ILS','symbol' => '₪','type' => 'FIAT','flag' => NULL,'rate' => '3.73989800','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Iraq','name' => 'Iraqi dinar','code' => 'IQD','symbol' => 'د.ع','type' => 'FIAT','flag' => NULL,'rate' => '1310.07880100','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Iran','name' => 'Iranian rial','code' => 'IRR','symbol' => '﷼','type' => 'FIAT','flag' => NULL,'rate' => '42092.51860600','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Iceland','name' => 'Icelandic króna','code' => 'ISK','symbol' => 'kr','type' => 'FIAT','flag' => NULL,'rate' => '134.36004800','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Jamaica','name' => 'Jamaican dollar','code' => 'JMD','symbol' => 'J$','type' => 'FIAT','flag' => NULL,'rate' => '156.61945100','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Jordan','name' => 'Jordanian dinar','code' => 'JOD','symbol' => 'ا.د','type' => 'FIAT','flag' => NULL,'rate' => '0.70860200','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Japan','name' => 'Japanese yen','code' => 'JPY','symbol' => '¥','type' => 'FIAT','flag' => NULL,'rate' => '144.15103000','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Kyrgyzstan','name' => 'Kyrgyzstani som','code' => 'KGS','symbol' => 'лв','type' => 'FIAT','flag' => NULL,'rate' => '84.20013500','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Cambodia','name' => 'Cambodian riel','code' => 'KHR','symbol' => 'KHR','type' => 'FIAT','flag' => NULL,'rate' => '4063.02380200','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Comoros','name' => 'Comorian franc','code' => 'KMF','symbol' => 'CF','type' => 'FIAT','flag' => NULL,'rate' => '441.95036400','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'North Korea','name' => 'North Korean Won','code' => 'KPW','symbol' => '₩','type' => 'FIAT','flag' => NULL,'rate' => '899.99943300','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'South Korea','name' => 'Won','code' => 'KRW','symbol' => '₩','type' => 'FIAT','flag' => NULL,'rate' => '1331.33022800','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Kuwait','name' => 'Kuwaiti dinar','code' => 'KWD','symbol' => 'ك.د','type' => 'FIAT','flag' => NULL,'rate' => '0.30523900','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Cayman Islands','name' => 'Cayman Islands dollar','code' => 'KYD','symbol' => '$','type' => 'FIAT','flag' => NULL,'rate' => '0.83344500','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Kazakhstan','name' => 'Kazakhstani tenge','code' => 'KZT','symbol' => 'лв','type' => 'FIAT','flag' => NULL,'rate' => '478.37300300','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Laos','name' => 'Lao kip','code' => 'LAK','symbol' => '₭','type' => 'FIAT','flag' => NULL,'rate' => '22083.36126900','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Lebanon','name' => 'Lebanese pound','code' => 'LBP','symbol' => '£','type' => 'FIAT','flag' => NULL,'rate' => '89557.58383000','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Sri Lanka','name' => 'Sri Lankan rupee','code' => 'LKR','symbol' => 'Rs','type' => 'FIAT','flag' => NULL,'rate' => '300.87562100','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Liberia','name' => 'Liberian dollar','code' => 'LRD','symbol' => '$','type' => 'FIAT','flag' => NULL,'rate' => '194.01497400','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Lesotho','name' => 'Lesotho loti','code' => 'LSL','symbol' => 'L','type' => 'FIAT','flag' => NULL,'rate' => '17.21678700','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Libya','name' => 'Libyan dinar','code' => 'LYD','symbol' => 'د.ل','type' => 'FIAT','flag' => NULL,'rate' => '4.75043200','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Morocco','name' => 'Moroccan dirham','code' => 'MAD','symbol' => 'DH','type' => 'FIAT','flag' => NULL,'rate' => '9.65774900','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Moldova','name' => 'Moldovan leu','code' => 'MDL','symbol' => 'L','type' => 'FIAT','flag' => NULL,'rate' => '17.40642400','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Macedonia','name' => 'Denar','code' => 'MKD','symbol' => 'ден','type' => 'FIAT','flag' => NULL,'rate' => '55.02936100','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Myanmar','name' => 'Burmese kyat','code' => 'MMK','symbol' => 'K','type' => 'FIAT','flag' => NULL,'rate' => '3247.96099200','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Mongolia','name' => 'Mongolian tögrög','code' => 'MNT','symbol' => '₮','type' => 'FIAT','flag' => NULL,'rate' => '3397.99995500','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Macau S.A.R.','name' => 'Macanese pataca','code' => 'MOP','symbol' => '$','type' => 'FIAT','flag' => NULL,'rate' => '8.02118700','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Mauritius','name' => 'Mauritian rupee','code' => 'MUR','symbol' => '₨','type' => 'FIAT','flag' => NULL,'rate' => '45.63985700','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Maldives','name' => 'Maldivian rufiyaa','code' => 'MVR','symbol' => 'Rf','type' => 'FIAT','flag' => NULL,'rate' => '15.35974000','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Malawi','name' => 'Malawian kwacha','code' => 'MWK','symbol' => 'MK','type' => 'FIAT','flag' => NULL,'rate' => '1733.83384700','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Mexico','name' => 'Mexican peso','code' => 'MXN','symbol' => '$','type' => 'FIAT','flag' => NULL,'rate' => '19.45390500','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Malaysia','name' => 'Malaysian ringgit','code' => 'MYR','symbol' => 'RM','type' => 'FIAT','flag' => NULL,'rate' => '4.13099100','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Mozambique','name' => 'Mozambican metical','code' => 'MZN','symbol' => 'MT','type' => 'FIAT','flag' => NULL,'rate' => '63.85044000','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Namibia','name' => 'Namibian dollar','code' => 'NAD','symbol' => '$','type' => 'FIAT','flag' => NULL,'rate' => '17.21678700','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Nicaragua','name' => 'Nicaraguan córdoba','code' => 'NIO','symbol' => 'C$','type' => 'FIAT','flag' => NULL,'rate' => '36.80378300','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Norway','name' => 'Norwegian krone','code' => 'NOK','symbol' => 'kr','type' => 'FIAT','flag' => NULL,'rate' => '10.45812000','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Nepal','name' => 'Nepalese rupee','code' => 'NPR','symbol' => '₨','type' => 'FIAT','flag' => NULL,'rate' => '133.82917600','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'New Zealand','name' => 'New Zealand dollar','code' => 'NZD','symbol' => '$','type' => 'FIAT','flag' => NULL,'rate' => '1.58349400','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Oman','name' => 'Omani rial','code' => 'OMR','symbol' => '.ع.ر','type' => 'FIAT','flag' => NULL,'rate' => '0.38496000','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Panama','name' => 'Panamanian balboa','code' => 'PAB','symbol' => 'B/.','type' => 'FIAT','flag' => NULL,'rate' => '1.00006700','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Peru','name' => 'Peruvian sol','code' => 'PEN','symbol' => 'S/.','type' => 'FIAT','flag' => NULL,'rate' => '3.76610800','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Papua new Guinea','name' => 'Papua New Guinean kina','code' => 'PGK','symbol' => 'K','type' => 'FIAT','flag' => NULL,'rate' => '3.97362800','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Philippines','name' => 'Philippine peso','code' => 'PHP','symbol' => '₱','type' => 'FIAT','flag' => NULL,'rate' => '55.96050400','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Poland','name' => 'Polish złoty','code' => 'PLN','symbol' => 'zł','type' => 'FIAT','flag' => NULL,'rate' => '3.80502500','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Paraguay','name' => 'Paraguayan guarani','code' => 'PYG','symbol' => '₲','type' => 'FIAT','flag' => NULL,'rate' => '7794.32075700','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Qatar','name' => 'Qatari riyal','code' => 'QAR','symbol' => 'ق.ر','type' => 'FIAT','flag' => NULL,'rate' => '3.64569300','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Romania','name' => 'Romanian leu','code' => 'RON','symbol' => 'lei','type' => 'FIAT','flag' => NULL,'rate' => '4.44280100','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Serbia','name' => 'Serbian dinar','code' => 'RSD','symbol' => 'din','type' => 'FIAT','flag' => NULL,'rate' => '104.53799200','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Russia','name' => 'Russian ruble','code' => 'RUB','symbol' => '₽','type' => 'FIAT','flag' => NULL,'rate' => '92.64955300','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Rwanda','name' => 'Rwandan franc','code' => 'RWF','symbol' => 'FRw','type' => 'FIAT','flag' => NULL,'rate' => '1356.12917600','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Saudi Arabia','name' => 'Saudi riyal','code' => 'SAR','symbol' => '﷼','type' => 'FIAT','flag' => NULL,'rate' => '3.75183200','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Solomon Islands','name' => 'Solomon Islands dollar','code' => 'SBD','symbol' => 'Si$','type' => 'FIAT','flag' => NULL,'rate' => '8.30973100','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Seychelles','name' => 'Seychellois rupee','code' => 'SCR','symbol' => 'SRe','type' => 'FIAT','flag' => NULL,'rate' => '12.62400300','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Sweden','name' => 'Swedish krona','code' => 'SEK','symbol' => 'kr','type' => 'FIAT','flag' => NULL,'rate' => '10.09909000','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Singapore','name' => 'Singapore dollar','code' => 'SGD','symbol' => '$','type' => 'FIAT','flag' => NULL,'rate' => '1.28469000','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Saint Helena','name' => 'Saint Helena pound','code' => 'SHP','symbol' => '£','type' => 'FIAT','flag' => NULL,'rate' => '0.76155900','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Sierra Leone','name' => 'Sierra Leonean leone','code' => 'SLL','symbol' => 'Le','type' => 'FIAT','flag' => NULL,'rate' => '20969.49485800','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Somalia','name' => 'Somali shilling','code' => 'SOS','symbol' => 'Sh.so.','type' => 'FIAT','flag' => NULL,'rate' => '571.58948200','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Suriname','name' => 'Surinamese dollar','code' => 'SRD','symbol' => '$','type' => 'FIAT','flag' => NULL,'rate' => '30.24898300','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Sao Tome and Principe','name' => 'Dobra','code' => 'STD','symbol' => 'Db','type' => 'FIAT','flag' => NULL,'rate' => '20697.98100800','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Syria','name' => 'Syrian pound','code' => 'SYP','symbol' => 'LS','type' => 'FIAT','flag' => NULL,'rate' => '2512.52993600','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Swaziland','name' => 'Lilangeni','code' => 'SZL','symbol' => 'E','type' => 'FIAT','flag' => NULL,'rate' => '17.20489700','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Thailand','name' => 'Thai baht','code' => 'THB','symbol' => '฿','type' => 'FIAT','flag' => NULL,'rate' => '32.65549900','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Tajikistan','name' => 'Tajikistani somoni','code' => 'TJS','symbol' => 'SM','type' => 'FIAT','flag' => NULL,'rate' => '10.64587900','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Turkmenistan','name' => 'Turkmenistan manat','code' => 'TMT','symbol' => 'T','type' => 'FIAT','flag' => NULL,'rate' => '3.50000000','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Tunisia','name' => 'Tunisian dinar','code' => 'TND','symbol' => 'ت.د','type' => 'FIAT','flag' => NULL,'rate' => '3.02136100','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Tonga','name' => 'Tongan paʻanga','code' => 'TOP','symbol' => '$','type' => 'FIAT','flag' => NULL,'rate' => '2.34209700','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Turkey','name' => 'Turkish lira','code' => 'TRY','symbol' => '₺','type' => 'FIAT','flag' => NULL,'rate' => '34.11818000','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Trinidad And Tobago','name' => 'Trinidad and Tobago dollar','code' => 'TTD','symbol' => '$','type' => 'FIAT','flag' => NULL,'rate' => '6.80478300','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Taiwan','name' => 'New Taiwan dollar','code' => 'TWD','symbol' => '$','type' => 'FIAT','flag' => NULL,'rate' => '31.88902300','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Tanzania','name' => 'Tanzanian shilling','code' => 'TZS','symbol' => 'TSh','type' => 'FIAT','flag' => NULL,'rate' => '2719.99984700','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Ukraine','name' => 'Ukrainian hryvnia','code' => 'UAH','symbol' => '₴','type' => 'FIAT','flag' => NULL,'rate' => '41.23893200','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Uganda','name' => 'Ugandan shilling','code' => 'UGX','symbol' => 'USh','type' => 'FIAT','flag' => NULL,'rate' => '3692.89357100','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Uruguay','name' => 'Uruguayan peso','code' => 'UYU','symbol' => '$','type' => 'FIAT','flag' => NULL,'rate' => '42.12314200','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Uzbekistan','name' => 'Uzbekistani soʻm','code' => 'UZS','symbol' => 'лв','type' => 'FIAT','flag' => NULL,'rate' => '12755.83864100','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Venezuela','name' => 'Bolívar','code' => 'VEF','symbol' => 'Bs','type' => 'FIAT','flag' => NULL,'rate' => '3622552.53443400','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' =>now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Vietnam','name' => 'Vietnamese đồng','code' => 'VND','symbol' => '₫','type' => 'FIAT','flag' => NULL,'rate' => '24595.00000000','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Vanuatu','name' => 'Vanuatu vatu','code' => 'VUV','symbol' => 'VT','type' => 'FIAT','flag' => NULL,'rate' => '118.72200900','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Samoa','name' => 'Samoan tālā','code' => 'WST','symbol' => 'SAT','type' => 'FIAT','flag' => NULL,'rate' => '2.79746300','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Central African Republic','name' => 'Central African CFA franc','code' => 'XAF','symbol' => 'FCFA','type' => 'FIAT','flag' => NULL,'rate' => '586.39579800','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Grenada','name' => 'Eastern Caribbean dollar','code' => 'XCD','symbol' => '$','type' => 'FIAT','flag' => NULL,'rate' => '2.70255000','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Wallis And Futuna Islands','name' => 'CFP franc','code' => 'XPF','symbol' => '₣','type' => 'FIAT','flag' => NULL,'rate' => '106.61207600','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Yemen','name' => 'Yemeni rial','code' => 'YER','symbol' => '﷼','type' => 'FIAT','flag' => NULL,'rate' => '250.29942000','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Zambia','name' => 'Zambian kwacha','code' => 'ZMW','symbol' => 'ZK','type' => 'FIAT','flag' => NULL,'rate' => '26.52709100','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now()),
            array('admin_id' => '1','country' => 'Zimbabwe','name' => 'Zimbabwe Dollar','code' => 'ZWL','symbol' => '$','type' => 'FIAT','flag' => NULL,'rate' => '321.99959200','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => now(),'updated_at' => now())

        );
        Currency::upsert($currencies,['country'],['country','name','code','rate']);
    }
}
