(function ($) {
"user strict";

//Create Background Image
(function background() {
  let img = $('.bg_img');
  img.css('background-image', function () {
    var bg = ('url(' + $(this).data('background') + ')');
    return bg;
  });
})();

// lightcase
$(window).on('load', function () {
  $("a[data-rel^=lightcase]").lightcase();
})

// header-fixed
// var fixed_top = $(".header-section");
// $(window).on("scroll", function(){
//     if( $(window).scrollTop() > 0){  
//         fixed_top.addClass("animated fadeInDown header-fixed");
//     }
//     else{
//         fixed_top.removeClass("animated fadeInDown header-fixed");
//     }
// });

// navbar-click
$(".navbar li a").on("click", function () {
  var element = $(this).parent("li");
  if (element.hasClass("show")) {
    element.removeClass("show");
    element.children("ul").slideUp(500);
  }
  else {
    element.siblings("li").removeClass('show');
    element.addClass("show");
    element.siblings("li").find("ul").slideUp(500);
    element.children('ul').slideDown(500);
  }
});

// scroll-to-top
var ScrollTop = $(".scrollToTop");
$(window).on('scroll', function () {
  if ($(this).scrollTop() < 100) {
      ScrollTop.removeClass("active");
  } else {
      ScrollTop.addClass("active");
  }
});

// sidebar
$(".sidebar-menu-item > a").on("click", function () {
  var element = $(this).parent("li");
  if (element.hasClass("active")) {
    element.removeClass("active");
    element.children("ul").slideUp(500);
  }
  else {
    element.siblings("li").removeClass('active');
    element.addClass("active");
    element.siblings("li").find("ul").slideUp(500);
    element.children('ul').slideDown(500);
  }
});

// active menu JS
function splitSlash(data) {
  return data.split('/').pop();
}
function splitQuestion(data) {
  return data.split('?').shift().trim();
}
var pageNavLis = $('.sidebar-menu a');
var dividePath = splitSlash(window.location.href);
var divideGetData = splitQuestion(dividePath);
var currentPageUrl = divideGetData;

// find current sidevar element
$.each(pageNavLis,function(index,item){
    var anchoreTag = $(item);
    var anchoreTagHref = $(item).attr('href');
    var index = anchoreTagHref.indexOf('/');
    var getUri = "";
    if(index != -1) {
      // split with /
      getUri = splitSlash(anchoreTagHref);
      getUri = splitQuestion(getUri);
    }else {
      getUri = splitQuestion(anchoreTagHref);
    }
    if(getUri == currentPageUrl) {
      var thisElementParent = anchoreTag.parents('.sidebar-menu-item');
      (anchoreTag.hasClass('nav-link') == true) ? anchoreTag.addClass('active') : thisElementParent.addClass('active');
      (anchoreTag.parents('.sidebar-dropdown')) ? anchoreTag.parents('.sidebar-dropdown').addClass('active') : '';
      (thisElementParent.find('.sidebar-submenu')) ? thisElementParent.find('.sidebar-submenu').slideDown("slow") : '';
      return false;
    }
});

//sidebar Menu
$('.sidebar-menu-bar').on('click', function (e) {
  e.preventDefault();
  if($('.sidebar').hasClass('active')) {
    $('.sidebar').removeClass('active');
    $('.body-overlay').removeClass('active');
  }else {
    $('.sidebar').addClass('active');
    $('.body-overlay').addClass('active');
  }
});
$('#body-overlay').on('click', function (e) {
  e.preventDefault();
  $('.sidebar').removeClass('active');
  $('.body-overlay').removeClass('active');
});

//right sidebar Menu
$('.right-sidebar-menu-bar').on('click', function (e) {
  e.preventDefault();
  if($('.right-sidebar').hasClass('active')) {
    $('.right-sidebar').removeClass('active');
    $('.body-overlay').removeClass('active');
  }else {
    $('.right-sidebar').addClass('active');
    $('.body-overlay').addClass('active');
  }
});
$('#body-overlay').on('click', function (e) {
  e.preventDefault();
  $('.right-sidebar').removeClass('active');
  $('.body-overlay').removeClass('active');
});


// $(document).ready(function(){
//   var active = $(".sidebar-menu-item.active");
//   activeMenu(active);
// });

// $(".sidebar-menu-item").click(function(){
//   activeMenu($(this));
// });

// function activeMenu(menu) {
//   if(menu == undefined) {
//     return false;
//   }

//   if($(menu).hasClass("active") == false) {
//     return false;
//   }
//   var anchore = $(menu).find("a").attr("href").replace("#","");
//   var commonClass = "doc-wrapper";
//   $("."+commonClass).hide();
//   $("."+anchore+"-section").show();
// }



})(jQuery);