@extends('admin.layouts.master')

@push('css')
@endpush

@section('page-title')
    @include('admin.components.page-title', ['title' => __($page_title)])
@endsection

@section('breadcrumb')
    @include('admin.components.breadcrumb', [
        'breadcrumbs' => [
            [
                'name' => __('Dashboard'),
                'url' => setRoute('admin.dashboard'),
            ],
        ],
        'active' => __('Merchant Care'),
    ])
@endsection

@section('content')
    <div class="table-area">
        <div class="table-wrapper">
            <div class="table-header">
                <h5 class="title">{{ $page_title }}</h5>
            </div>
            <div class="table-responsive">
                <div class="table-area">
                    <div class="table-wrapper">
                        <div class="table-header">
                            <h5 class="title">{{ __("Merchant Email Logs") }}</h5>
                        </div>
                        <div class="table-responsive">
                            <table class="custom-table">
                                <thead>
                                    <tr>
                                        <th></th>
                                        <th>{{ __("Merchant") }}</th>
                                        <th>{{ __("send") }}</th>
                                        <th>{{ __("Mail Sender(Method)") }}</th>
                                        <th>{{ __("Subject") }}</th>
                                        <th>{{ __("Message") }}</th>
                                        <th></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @forelse ($logs as $key => $item)
                                        <tr>
                                            <td>
                                                <ul class="user-list">
                                                    <li><img src="{{ $item->merchant->userImage }}" alt="user"></li>
                                                </ul>
                                            </td>
                                            <td>{{ $item->merchant->username }}</td>
                                            <td>{{ $item->created_at->format("Y-m-d H:i") }}</td>
                                            <td>{{ $item->method ?? "SMTP" }}</td>
                                            <td>{{ $item->subject }}</td>
                                            <td title="{{ strip_tags($item->message) }}">{{ Str::words(strip_tags($item->message), 5, '...') }}</td>
                                            <td>
                                                <a href="{{ setRoute('admin.merchants.details',$item->merchant->username) }}" class="btn btn--base"><i class="las la-info-circle"></i></a>
                                            </td>
                                        </tr>
                                    @empty
                                        @include('admin.components.alerts.empty',['colspan' => 7])
                                    @endforelse
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        {{ get_paginate($logs) }}
    </div>
@endsection

@push('script')

@endpush
