<?php

/**
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Verify
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


namespace Twilio\Rest\Verify\V2\Service;

use Twilio\Exceptions\TwilioException;
use Twilio\InstanceResource;
use Twilio\Values;
use Twilio\Version;
use Twilio\Deserialize;


/**
 * @property array $options
 * @property string|null $sid
 * @property string|null $accountSid
 * @property string|null $serviceSid
 * @property string|null $entitySid
 * @property string|null $identity
 * @property string|null $factorSid
 * @property \DateTime|null $dateCreated
 * @property \DateTime|null $dateUpdated
 * @property \DateTime|null $dateResponded
 * @property \DateTime|null $expirationDate
 * @property string $status
 * @property string $respondedReason
 * @property array|null $details
 * @property array|null $hiddenDetails
 * @property array|null $metadata
 * @property string $factorType
 * @property string|null $url
 * @property array|null $links
 */
class NewChallengeInstance extends InstanceResource
{
    /**
     * Initialize the NewChallengeInstance
     *
     * @param Version $version Version that contains the resource
     * @param mixed[] $payload The response payload
     * @param string $serviceSid The unique SID identifier of the Service.
     */
    public function __construct(Version $version, array $payload, string $serviceSid)
    {
        parent::__construct($version);

        // Marshaled Properties
        $this->properties = [
            'options' => Values::array_get($payload, 'options'),
            'sid' => Values::array_get($payload, 'sid'),
            'accountSid' => Values::array_get($payload, 'account_sid'),
            'serviceSid' => Values::array_get($payload, 'service_sid'),
            'entitySid' => Values::array_get($payload, 'entity_sid'),
            'identity' => Values::array_get($payload, 'identity'),
            'factorSid' => Values::array_get($payload, 'factor_sid'),
            'dateCreated' => Deserialize::dateTime(Values::array_get($payload, 'date_created')),
            'dateUpdated' => Deserialize::dateTime(Values::array_get($payload, 'date_updated')),
            'dateResponded' => Deserialize::dateTime(Values::array_get($payload, 'date_responded')),
            'expirationDate' => Deserialize::dateTime(Values::array_get($payload, 'expiration_date')),
            'status' => Values::array_get($payload, 'status'),
            'respondedReason' => Values::array_get($payload, 'responded_reason'),
            'details' => Values::array_get($payload, 'details'),
            'hiddenDetails' => Values::array_get($payload, 'hidden_details'),
            'metadata' => Values::array_get($payload, 'metadata'),
            'factorType' => Values::array_get($payload, 'factor_type'),
            'url' => Values::array_get($payload, 'url'),
            'links' => Values::array_get($payload, 'links'),
        ];

        $this->solution = ['serviceSid' => $serviceSid, ];
    }

    /**
     * Generate an instance context for the instance, the context is capable of
     * performing various actions.  All instance actions are proxied to the context
     *
     * @return NewChallengeContext Context for this NewChallengeInstance
     */
    protected function proxy(): NewChallengeContext
    {
        if (!$this->context) {
            $this->context = new NewChallengeContext(
                $this->version,
                $this->solution['serviceSid']
            );
        }

        return $this->context;
    }

    /**
     * Create the NewChallengeInstance
     *
     * @param CreatePasskeysChallengeRequest $createPasskeysChallengeRequest
     * @return NewChallengeInstance Created NewChallengeInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function create(CreatePasskeysChallengeRequest $createPasskeysChallengeRequest): NewChallengeInstance
    {

        return $this->proxy()->create($createPasskeysChallengeRequest);
    }

    /**
     * Magic getter to access properties
     *
     * @param string $name Property to access
     * @return mixed The requested property
     * @throws TwilioException For unknown properties
     */
    public function __get(string $name)
    {
        if (\array_key_exists($name, $this->properties)) {
            return $this->properties[$name];
        }

        if (\property_exists($this, '_' . $name)) {
            $method = 'get' . \ucfirst($name);
            return $this->$method();
        }

        throw new TwilioException('Unknown property: ' . $name);
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string
    {
        $context = [];
        foreach ($this->solution as $key => $value) {
            $context[] = "$key=$value";
        }
        return '[Twilio.Verify.V2.NewChallengeInstance ' . \implode(' ', $context) . ']';
    }
}

